/*
 * Decompiled with CFR 0.152.
 */
package springfox.bean.validators.plugins.parameter;

import com.google.common.base.Optional;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.bean.validators.plugins.RangeAnnotations;
import springfox.bean.validators.plugins.Validators;
import springfox.documentation.service.AllowableRangeValues;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;

@Component
@Order(value=-2147483148)
public class MinMaxAnnotationPlugin
implements ParameterBuilderPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(MinMaxAnnotationPlugin.class);

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    public void apply(ParameterContext context) {
        Optional<Min> min = Validators.annotationFromParameter(context, Min.class);
        Optional<Max> max = Validators.annotationFromParameter(context, Max.class);
        if (min.isPresent() || max.isPresent()) {
            AllowableRangeValues values = RangeAnnotations.allowableRange(min, max);
            LOG.debug("adding allowable Values: " + values.getMin() + " - " + values.getMax());
            context.parameterBuilder().allowableValues((AllowableValues)values);
        }
    }
}

