/*
 * Decompiled with CFR 0.152.
 */
package net.samuelcampos.usbdrivedetector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.samuelcampos.usbdrivedetector.USBStorageDevice;
import net.samuelcampos.usbdrivedetector.detectors.AbstractStorageDeviceDetector;
import net.samuelcampos.usbdrivedetector.events.DeviceEventType;
import net.samuelcampos.usbdrivedetector.events.IUSBDriveListener;
import net.samuelcampos.usbdrivedetector.events.USBStorageEvent;
import net.samuelcampos.usbdrivedetector.unmounters.AbstractStorageDeviceUnmounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class USBDeviceDetectorManager {
    private static final Logger log = LoggerFactory.getLogger(USBDeviceDetectorManager.class);
    private static final long DEFAULT_POLLING_INTERVAL = 5000L;
    private final Set<USBStorageDevice> connectedDevices;
    private final List<IUSBDriveListener> listeners = new ArrayList<IUSBDriveListener>();
    private long currentPollingInterval;
    private ListenerTask listenerTask;

    public USBDeviceDetectorManager() {
        this(5000L);
    }

    public USBDeviceDetectorManager(long pollingInterval) {
        this.connectedDevices = new HashSet<USBStorageDevice>();
        this.currentPollingInterval = pollingInterval;
    }

    public synchronized void setPollingInterval(long pollingInterval) {
        if (pollingInterval <= 0L) {
            throw new IllegalArgumentException("'pollingInterval' must be greater than 0");
        }
        this.currentPollingInterval = pollingInterval;
        if (this.listeners.size() > 0) {
            this.stop();
            this.start();
        }
    }

    private synchronized void start() {
        if (this.listenerTask == null) {
            this.listenerTask = new ListenerTask(this.currentPollingInterval);
            this.listenerTask.start();
        }
    }

    private synchronized void stop() {
        try {
            if (this.listenerTask != null) {
                this.listenerTask.interrupt();
                this.listenerTask.join(2L * this.currentPollingInterval);
                this.listenerTask = null;
            }
        }
        catch (InterruptedException e) {
            log.error("Unable to with for 'listenerTask' to die.", (Throwable)e);
        }
    }

    public synchronized boolean addDriveListener(IUSBDriveListener listener) {
        if (this.listeners.contains(listener)) {
            return false;
        }
        this.listeners.add(listener);
        this.start();
        return true;
    }

    public synchronized boolean removeDriveListener(IUSBDriveListener listener) {
        boolean removed = this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.stop();
        }
        return removed;
    }

    public List<USBStorageDevice> getRemovableDevices() {
        return AbstractStorageDeviceDetector.getInstance().getStorageDevicesDevices();
    }

    public void unmountStorageDevice(USBStorageDevice usbStorageDevice) throws IOException {
        AbstractStorageDeviceUnmounter.getInstance().unmount(usbStorageDevice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConnectedDevices(List<USBStorageDevice> currentConnectedDevices) {
        ArrayList<USBStorageDevice> removedDevices = new ArrayList<USBStorageDevice>();
        USBDeviceDetectorManager uSBDeviceDetectorManager = this;
        synchronized (uSBDeviceDetectorManager) {
            Iterator<USBStorageDevice> itConnectedDevices = this.connectedDevices.iterator();
            while (itConnectedDevices.hasNext()) {
                USBStorageDevice device2 = itConnectedDevices.next();
                if (currentConnectedDevices.contains(device2)) {
                    currentConnectedDevices.remove(device2);
                    continue;
                }
                removedDevices.add(device2);
                itConnectedDevices.remove();
            }
            this.connectedDevices.addAll(currentConnectedDevices);
        }
        currentConnectedDevices.forEach(device -> this.sendEventToListeners(new USBStorageEvent((USBStorageDevice)device, DeviceEventType.CONNECTED)));
        removedDevices.forEach(device -> this.sendEventToListeners(new USBStorageEvent((USBStorageDevice)device, DeviceEventType.REMOVED)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEventToListeners(USBStorageEvent event) {
        ArrayList<IUSBDriveListener> listenersCopy;
        List<IUSBDriveListener> list = this.listeners;
        synchronized (list) {
            listenersCopy = new ArrayList<IUSBDriveListener>(this.listeners);
        }
        for (IUSBDriveListener listener : listenersCopy) {
            try {
                listener.usbDriveEvent(event);
            }
            catch (Exception ex) {
                log.error("An IUSBDriveListener threw an exception", (Throwable)ex);
            }
        }
    }

    private class ListenerTask
    extends Thread {
        private final long pollingInterval;

        public ListenerTask(long pollingInterval) {
            this.pollingInterval = pollingInterval;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            block5: {
                try {
                    while (!Thread.currentThread().isInterrupted()) {
                        try {
                            log.trace("Polling refresh task is running");
                            List<USBStorageDevice> actualConnectedDevices = USBDeviceDetectorManager.this.getRemovableDevices();
                            USBDeviceDetectorManager.this.updateConnectedDevices(actualConnectedDevices);
                        }
                        catch (Exception e) {
                            log.error("Error while refreshing device list", (Throwable)e);
                        }
                        ListenerTask.sleep(this.pollingInterval);
                    }
                }
                catch (InterruptedException ex) {
                    if (ex.getMessage().equalsIgnoreCase("sleep interrupted")) break block5;
                    log.error("Stopping polling thread", (Throwable)ex);
                }
            }
        }
    }
}

