/*
 * Decompiled with CFR 0.152.
 */
package net.samuelcampos.usbdrivedetector.detectors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.samuelcampos.usbdrivedetector.USBStorageDevice;
import net.samuelcampos.usbdrivedetector.detectors.AbstractStorageDeviceDetector;
import net.samuelcampos.usbdrivedetector.detectors.DiskInfo;
import net.samuelcampos.usbdrivedetector.process.CommandExecutor;
import net.samuelcampos.usbdrivedetector.utils.OSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSXStorageDeviceDetector
extends AbstractStorageDeviceDetector {
    private static final Logger log = LoggerFactory.getLogger(OSXStorageDeviceDetector.class);
    private static final String CMD_SYSTEM_PROFILER_USB = "system_profiler SPUSBDataType";
    private static final Pattern macOSXPattern_MOUNT = Pattern.compile("^.*Mount Point: (.+)$");
    private static final String CMD_DF = "df -l";
    private static final String CMD_DISKUTIL = "diskutil info ";
    private static final String DISK_PREFIX = "/dev/disk";
    private static final String INFO_MOUNTPOINT = "Mount Point";
    private static final String INFO_PROTOCOL = "Protocol";
    private static final String INFO_USB = "USB";
    private static final String INFO_NAME = "Volume Name";
    private static final String INFO_UUID = "Volume UUID";
    private static final int MACOSX_MOUNTAINLION = 8;
    private int macosVersion = -1;

    protected OSXStorageDeviceDetector() {
        String version = OSUtils.getOsVersion();
        String[] versionParts = version.split("\\.");
        if (versionParts.length > 1) {
            try {
                this.macosVersion = Integer.parseInt(versionParts[1]);
            }
            catch (NumberFormatException nfe) {
                log.error(nfe.getMessage(), (Throwable)nfe);
            }
        }
    }

    @Override
    public List<USBStorageDevice> getStorageDevicesDevices() {
        ArrayList<USBStorageDevice> listDevices = new ArrayList<USBStorageDevice>();
        if (this.macosVersion >= 8) {
            try (CommandExecutor commandExecutor = new CommandExecutor(CMD_DF);){
                commandExecutor.processOutput(outputLine -> {
                    DiskInfo disk;
                    String[] parts = outputLine.split("\\s");
                    String device = parts[0];
                    if (device.startsWith(DISK_PREFIX) && (disk = this.getDiskInfo(device)).isUSB()) {
                        OSXStorageDeviceDetector.getUSBDevice(disk.getMountPoint(), disk.getName(), disk.getDevice(), disk.getUuid()).ifPresent(listDevices::add);
                    }
                });
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        } else {
            try (CommandExecutor commandExecutor = new CommandExecutor(CMD_SYSTEM_PROFILER_USB);){
                commandExecutor.processOutput(outputLine -> {
                    Matcher matcher = macOSXPattern_MOUNT.matcher((CharSequence)outputLine);
                    if (matcher.matches()) {
                        OSXStorageDeviceDetector.getUSBDevice(matcher.group(1)).ifPresent(listDevices::add);
                    }
                });
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return listDevices;
    }

    private DiskInfo getDiskInfo(String device) {
        DiskInfo disk = new DiskInfo(device);
        String command = CMD_DISKUTIL + disk.getDevice();
        try (CommandExecutor commandExecutor = new CommandExecutor(command);){
            commandExecutor.processOutput(outputLine -> {
                String[] parts = outputLine.split(":");
                if (parts.length > 1) {
                    switch (parts[0].trim()) {
                        case "Mount Point": {
                            disk.setMountPoint(parts[1].trim());
                            break;
                        }
                        case "Protocol": {
                            disk.setUSB(INFO_USB.equals(parts[1].trim()));
                            break;
                        }
                        case "Volume Name": {
                            disk.setName(parts[1].trim());
                            break;
                        }
                        case "Volume UUID": {
                            disk.setUuid(parts[1].trim());
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return disk;
    }
}

