/*
 * Decompiled with CFR 0.152.
 */
package net.samuelcampos.usbdrivedetector.unmounters;

import java.io.IOException;
import net.samuelcampos.usbdrivedetector.USBStorageDevice;
import net.samuelcampos.usbdrivedetector.process.CommandExecutor;
import net.samuelcampos.usbdrivedetector.unmounters.AbstractStorageDeviceUnmounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxStorageDeviceUnmounter
extends AbstractStorageDeviceUnmounter {
    private static final Logger log = LoggerFactory.getLogger(LinuxStorageDeviceUnmounter.class);

    @Override
    public void unmount(USBStorageDevice usbStorageDevice) throws IOException {
        try {
            this.unmount("umount " + usbStorageDevice.getDevice());
        }
        catch (IOException e) {
            this.unmount("sudo umount " + usbStorageDevice.getDevice());
        }
    }

    private void unmount(String command) throws IOException {
        try (CommandExecutor commandExecutor = new CommandExecutor(command);){
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            log.error("Unable to unmount device", (Throwable)e);
        }
    }
}

