/*
 * Decompiled with CFR 0.152.
 */
package net.samuelcampos.usbdrivedetector.utils;

import net.samuelcampos.usbdrivedetector.utils.OSType;

public final class OSUtils {
    public static final String OS_NAME = System.getProperty("os.name");

    public static OSType getOsType() {
        String osNameLower = OS_NAME.toLowerCase();
        if (osNameLower.startsWith("win")) {
            return OSType.WINDOWS;
        }
        if (osNameLower.startsWith("linux")) {
            return OSType.LINUX;
        }
        if (osNameLower.startsWith("mac")) {
            return OSType.MAC_OS;
        }
        throw new UnsupportedOperationException("Your Operative System (" + osNameLower + ") is not supported!");
    }

    public static String getOsVersion() {
        return System.getProperty("os.version");
    }

    private OSUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

