/*
 * Decompiled with CFR 0.152.
 */
package net.samuelcampos.usbdrivedetector.process;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandExecutor
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(CommandExecutor.class);
    private final String command;
    private final BufferedReader input;
    private final Process process;

    public CommandExecutor(String command) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace("Running command: {}", (Object)command);
        }
        this.command = command;
        this.process = Runtime.getRuntime().exec(command);
        this.input = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
    }

    public void processOutput(Consumer<String> method) throws IOException {
        String outputLine;
        while ((outputLine = this.readOutputLine()) != null) {
            method.accept(outputLine);
        }
    }

    public boolean checkOutput(Predicate<String> method) throws IOException {
        String outputLine;
        while ((outputLine = this.readOutputLine()) != null) {
            if (!method.test(outputLine)) continue;
            return true;
        }
        return false;
    }

    private String readOutputLine() throws IOException {
        if (this.input == null) {
            throw new IllegalStateException("You need to call 'executeCommand' method first");
        }
        String outputLine = this.input.readLine();
        if (outputLine != null) {
            return outputLine.trim();
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        try {
            int exitValue = this.process.waitFor();
            if (exitValue != 0) {
                log.warn("Abnormal command '{}' terminantion. Exit value: {}", (Object)this.command, (Object)exitValue);
            }
        }
        catch (InterruptedException e) {
            log.error("Error while waiting for command '{}' to complete", (Object)this.command, (Object)e);
        }
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        this.process.destroy();
    }
}

