/*
 * Decompiled with CFR 0.152.
 */
package copy;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import org.apache.commons.lang3.SystemUtils;

public class Main {
    public static void main(String[] args) throws IOException {
        if (args == null || args.length < 2) {
            return;
        }
        Main main = new Main();
        main.execute(args);
    }

    private void execute(String[] args) throws IOException {
        block17: {
            String logFile = "update-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) + ".log";
            try (FileWriter writer = new FileWriter("." + File.separator + "log" + File.separator + logFile);){
                try {
                    Main.waitForLock(writer);
                    Path sourceDir = Paths.get(args[0].replace("\"", ""), new String[0]);
                    Path targetDir = Paths.get(args[1].replace("\"", ""), new String[0]);
                    writer.append("\r\n" + LocalDateTime.now().toString() + "\r\n");
                    Files.walk(sourceDir, new FileVisitOption[0]).forEach(sourcePath -> {
                        try {
                            Path targetPath = targetDir.resolve(sourceDir.relativize((Path)sourcePath));
                            writer.append(String.format("cp %s > %s%n", sourcePath, targetPath));
                            Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException ex) {
                            try {
                                writer.append(String.format("I/O error: %s%n", ex));
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    String executableName = SystemUtils.IS_OS_WINDOWS ? "myLPFR.exe" : "myLPFR.sh";
                    File executable = new File(targetDir.toString() + File.separator + executableName);
                    File startInDir = new File(executable.getParent());
                    if (executable.exists()) {
                        writer.append("Running executable: " + executable.getAbsolutePath() + " in: " + startInDir + "\r\n");
                        ProcessBuilder pb = new ProcessBuilder(executable.getAbsolutePath());
                        pb.directory(startInDir);
                        Process proc = pb.start();
                        int len = proc.getErrorStream().available();
                        if (len > 0) {
                            byte[] buf = new byte[len];
                            proc.getErrorStream().read(buf);
                            writer.append("Command error: \t\"" + new String(buf) + "\"");
                        } else {
                            this.deleteDirectory(sourceDir.getParent(), writer);
                            writer.append("Update succeeded");
                        }
                        break block17;
                    }
                    writer.append("Couldn't find executable: " + executable.getAbsolutePath());
                }
                catch (Exception e1) {
                    writer.append(e1.getMessage());
                }
            }
        }
    }

    private static void waitForLock(FileWriter writter) throws IOException, InterruptedException {
        Thread.sleep(200L);
        File fileToLock = new File("." + File.separator + "temp" + File.separator + "lock");
        if (!fileToLock.exists()) {
            return;
        }
        try (FileChannel channel = new RandomAccessFile(fileToLock, "rw").getChannel();){
            FileLock lock = null;
            for (int count = 0; lock == null && count < 200; ++count) {
                Thread.sleep(200L);
                writter.append(". ");
                lock = channel.tryLock();
            }
            if (lock == null) {
                throw new RuntimeException("Operation failed. Couldn't acquire lock.");
            }
            lock.release();
        }
    }

    public void deleteDirectory(Path pathToBeDeleted, FileWriter writer) throws IOException {
        if (pathToBeDeleted.getFileName().toString().equals(".myLPFR")) {
            writer.append("Removing directory: " + pathToBeDeleted.toString() + "\r\n");
            Files.walk(pathToBeDeleted, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
    }
}

