/*
 * Decompiled with CFR 0.152.
 */
package com.notification.manager;

import com.notification.Notification;
import com.notification.NotificationFactory;
import com.notification.NotificationListener;
import com.notification.manager.SimpleManager;
import com.utils.Time;
import java.util.ArrayList;
import java.util.List;

public class SequenceManager
extends SimpleManager {
    private List<NotificationShowTime> m_sequence = new ArrayList<NotificationShowTime>();
    private Notification m_currentNotification;

    public SequenceManager() {
    }

    public SequenceManager(NotificationFactory.Location loc) {
        super(loc);
    }

    @Override
    public void notificationAdded(Notification notification, Time time) {
        notification.addNotificationListener(new CloseListener());
        if (this.m_currentNotification == null) {
            this.m_currentNotification = notification;
            this.superAdded(notification, time);
        } else {
            this.m_sequence.add(new NotificationShowTime(notification, time));
        }
    }

    private void superAdded(Notification notification, Time time) {
        super.notificationAdded(notification, time);
    }

    private class NotificationShowTime {
        public Notification notification;
        public Time time;

        public NotificationShowTime(Notification notification, Time time) {
            this.notification = notification;
            this.time = time;
        }
    }

    private class CloseListener
    implements NotificationListener {
        private CloseListener() {
        }

        @Override
        public void actionCompleted(Notification notification, String action) {
            if (action.equals("hidden")) {
                SequenceManager.this.m_currentNotification.removeNotificationListener(this);
                SequenceManager.this.m_currentNotification = null;
                if (!SequenceManager.this.m_sequence.isEmpty()) {
                    NotificationShowTime showing = (NotificationShowTime)SequenceManager.this.m_sequence.remove(0);
                    SequenceManager.this.m_currentNotification = showing.notification;
                    SequenceManager.this.superAdded(showing.notification, showing.time);
                }
            }
        }
    }
}

