/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.couchbase;

import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.CouchbaseBucket;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.couchbase.CouchbaseConfiguration;
import org.springframework.boot.autoconfigure.couchbase.CouchbaseProperties;
import org.springframework.boot.autoconfigure.couchbase.OnBootstrapHostsCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={CouchbaseBucket.class, Cluster.class})
@Conditional(value={CouchbaseCondition.class})
@EnableConfigurationProperties(value={CouchbaseProperties.class})
public class CouchbaseAutoConfiguration {

    static class CouchbaseCondition
    extends AnyNestedCondition {
        CouchbaseCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(type={"org.springframework.data.couchbase.config.CouchbaseConfigurer"})
        static class CouchbaseConfigurerAvailable {
            CouchbaseConfigurerAvailable() {
            }
        }

        @Conditional(value={OnBootstrapHostsCondition.class})
        static class BootstrapHostsProperty {
            BootstrapHostsProperty() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={CouchbaseConfiguration.class}, type={"org.springframework.data.couchbase.config.CouchbaseConfigurer"})
    @Import(value={CouchbaseConfiguration.class})
    static class DefaultCouchbaseConfiguration {
        DefaultCouchbaseConfiguration() {
        }
    }
}

