/*
 * Decompiled with CFR 0.152.
 */
package com.notification;

import com.notification.Notification;
import com.utils.Time;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public abstract class NotificationManager {
    private List<Notification> m_notifications = new ArrayList<Notification>();

    public final List<Notification> getNotifications() {
        return this.m_notifications;
    }

    public final void addNotification(Notification note, Time time) {
        if (!this.m_notifications.contains(note)) {
            note.setNotificationManager(this);
            this.m_notifications.add(note);
            this.notificationAdded(note, time);
        }
    }

    public final void removeNotification(Notification note) {
        if (this.m_notifications.contains(note)) {
            this.m_notifications.remove(note);
            this.notificationRemoved(note);
            note.setNotificationManager(null);
        }
    }

    protected abstract void notificationAdded(Notification var1, Time var2);

    protected abstract void notificationRemoved(Notification var1);

    protected void scheduleRemoval(Notification note, Time time) {
        if (!time.isInfinite()) {
            Timer removeTimer = new Timer();
            removeTimer.schedule((TimerTask)new RemoveTask(note), time.getMilliseconds());
        }
    }

    private class RemoveTask
    extends TimerTask {
        private Notification m_note;

        public RemoveTask(Notification note) {
            this.m_note = note;
        }

        @Override
        public void run() {
            NotificationManager.this.removeNotification(this.m_note);
        }
    }
}

