/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util.math.intpoly;

import java.math.BigInteger;
import sun.security.util.math.intpoly.IntegerPolynomial;

public class IntegerPolynomialP256
extends IntegerPolynomial {
    private static final int BITS_PER_LIMB = 26;
    private static final int NUM_LIMBS = 10;
    private static final int MAX_ADDS = 2;
    public static final BigInteger MODULUS = IntegerPolynomialP256.evaluateModulus();
    private static final long CARRY_ADD = 0x2000000L;
    private static final int LIMB_MASK = 0x3FFFFFF;

    public IntegerPolynomialP256() {
        super(26, 10, 2, MODULUS);
    }

    private static BigInteger evaluateModulus() {
        BigInteger bigInteger = BigInteger.valueOf(2L).pow(256);
        bigInteger = bigInteger.subtract(BigInteger.valueOf(2L).pow(224));
        bigInteger = bigInteger.add(BigInteger.valueOf(2L).pow(192));
        bigInteger = bigInteger.add(BigInteger.valueOf(2L).pow(96));
        bigInteger = bigInteger.subtract(BigInteger.valueOf(1L));
        return bigInteger;
    }

    @Override
    protected void finalCarryReduceLast(long[] lArray) {
        long l = lArray[9] >> 22;
        lArray[9] = lArray[9] - (l << 22);
        lArray[8] = lArray[8] + (l << 16 & 0x3FFFFFFL);
        lArray[9] = lArray[9] + (l >> 10);
        lArray[7] = lArray[7] - (l << 10 & 0x3FFFFFFL);
        lArray[8] = lArray[8] - (l >> 16);
        lArray[3] = lArray[3] - (l << 18 & 0x3FFFFFFL);
        lArray[4] = lArray[4] - (l >> 8);
        lArray[0] = lArray[0] + l;
    }

    private void carryReduce(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17, long l18, long l19) {
        long l20 = 0L;
        l17 += l19 << 20 & 0x3FFFFFFL;
        l18 += l19 >> 6;
        l16 -= l19 << 14 & 0x3FFFFFFL;
        l17 -= l19 >> 12;
        l12 -= l19 << 22 & 0x3FFFFFFL;
        l13 -= l19 >> 4;
        l9 += l19 << 4 & 0x3FFFFFFL;
        l10 += l19 >> 22;
        l16 += l18 << 20 & 0x3FFFFFFL;
        l17 += l18 >> 6;
        l15 -= l18 << 14 & 0x3FFFFFFL;
        l16 -= l18 >> 12;
        l11 -= l18 << 22 & 0x3FFFFFFL;
        l12 -= l18 >> 4;
        l8 += l18 << 4 & 0x3FFFFFFL;
        l9 += l18 >> 22;
        l15 += l17 << 20 & 0x3FFFFFFL;
        l16 += l17 >> 6;
        l14 -= l17 << 14 & 0x3FFFFFFL;
        l15 -= l17 >> 12;
        l10 -= l17 << 22 & 0x3FFFFFFL;
        l11 -= l17 >> 4;
        l7 += l17 << 4 & 0x3FFFFFFL;
        l8 += l17 >> 22;
        l14 += l16 << 20 & 0x3FFFFFFL;
        l15 += l16 >> 6;
        l13 -= l16 << 14 & 0x3FFFFFFL;
        l14 -= l16 >> 12;
        l9 -= l16 << 22 & 0x3FFFFFFL;
        l10 -= l16 >> 4;
        l6 += l16 << 4 & 0x3FFFFFFL;
        l7 += l16 >> 22;
        l13 += l15 << 20 & 0x3FFFFFFL;
        l14 += l15 >> 6;
        l12 -= l15 << 14 & 0x3FFFFFFL;
        l13 -= l15 >> 12;
        l8 -= l15 << 22 & 0x3FFFFFFL;
        l9 -= l15 >> 4;
        l5 += l15 << 4 & 0x3FFFFFFL;
        l6 += l15 >> 22;
        l12 += l14 << 20 & 0x3FFFFFFL;
        l13 += l14 >> 6;
        l11 -= l14 << 14 & 0x3FFFFFFL;
        l12 -= l14 >> 12;
        l7 -= l14 << 22 & 0x3FFFFFFL;
        l8 -= l14 >> 4;
        l4 += l14 << 4 & 0x3FFFFFFL;
        l5 += l14 >> 22;
        l11 += l13 << 20 & 0x3FFFFFFL;
        l12 += l13 >> 6;
        l10 -= l13 << 14 & 0x3FFFFFFL;
        l11 -= l13 >> 12;
        l6 -= l13 << 22 & 0x3FFFFFFL;
        l7 -= l13 >> 4;
        l3 += l13 << 4 & 0x3FFFFFFL;
        l4 += l13 >> 22;
        l10 += l12 << 20 & 0x3FFFFFFL;
        l11 += l12 >> 6;
        l9 -= l12 << 14 & 0x3FFFFFFL;
        l10 -= l12 >> 12;
        l5 -= l12 << 22 & 0x3FFFFFFL;
        l6 -= l12 >> 4;
        l2 += l12 << 4 & 0x3FFFFFFL;
        l3 += l12 >> 22;
        l9 += l11 << 20 & 0x3FFFFFFL;
        l10 += l11 >> 6;
        l8 -= l11 << 14 & 0x3FFFFFFL;
        l9 -= l11 >> 12;
        l4 -= l11 << 22 & 0x3FFFFFFL;
        l5 -= l11 >> 4;
        l += l11 << 4 & 0x3FFFFFFL;
        l2 += l11 >> 22;
        l11 = 0L;
        this.carryReduce0(lArray, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19, l20);
    }

    void carryReduce0(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17, long l18, long l19, long l20) {
        long l21 = l9 + 0x2000000L >> 26;
        l9 -= l21 << 26;
        l10 += l21;
        l21 = l10 + 0x2000000L >> 26;
        l10 -= l21 << 26;
        l9 += (l11 += l21) << 20 & 0x3FFFFFFL;
        l10 += l11 >> 6;
        l8 -= l11 << 14 & 0x3FFFFFFL;
        l9 -= l11 >> 12;
        l4 -= l11 << 22 & 0x3FFFFFFL;
        l5 -= l11 >> 4;
        l2 += l11 >> 22;
        l21 = (l += l11 << 4 & 0x3FFFFFFL) + 0x2000000L >> 26;
        l -= l21 << 26;
        l2 += l21;
        l21 = l2 + 0x2000000L >> 26;
        l2 -= l21 << 26;
        l3 += l21;
        l21 = l3 + 0x2000000L >> 26;
        l3 -= l21 << 26;
        l4 += l21;
        l21 = l4 + 0x2000000L >> 26;
        l4 -= l21 << 26;
        l5 += l21;
        l21 = l5 + 0x2000000L >> 26;
        l5 -= l21 << 26;
        l6 += l21;
        l21 = l6 + 0x2000000L >> 26;
        l6 -= l21 << 26;
        l7 += l21;
        l21 = l7 + 0x2000000L >> 26;
        l7 -= l21 << 26;
        l8 += l21;
        l21 = l8 + 0x2000000L >> 26;
        l8 -= l21 << 26;
        l9 += l21;
        l21 = l9 + 0x2000000L >> 26;
        l9 -= l21 << 26;
        l10 += l21;
        lArray[0] = l;
        lArray[1] = l2;
        lArray[2] = l3;
        lArray[3] = l4;
        lArray[4] = l5;
        lArray[5] = l6;
        lArray[6] = l7;
        lArray[7] = l8;
        lArray[8] = l9;
        lArray[9] = l10;
    }

    private void carryReduce(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10) {
        long l11 = 0L;
        long l12 = l9 + 0x2000000L >> 26;
        l9 -= l12 << 26;
        l10 += l12;
        l12 = l10 + 0x2000000L >> 26;
        l10 -= l12 << 26;
        l9 += (l11 += l12) << 20 & 0x3FFFFFFL;
        l10 += l11 >> 6;
        l8 -= l11 << 14 & 0x3FFFFFFL;
        l9 -= l11 >> 12;
        l4 -= l11 << 22 & 0x3FFFFFFL;
        l5 -= l11 >> 4;
        l2 += l11 >> 22;
        l12 = (l += l11 << 4 & 0x3FFFFFFL) + 0x2000000L >> 26;
        l -= l12 << 26;
        l2 += l12;
        l12 = l2 + 0x2000000L >> 26;
        l2 -= l12 << 26;
        l3 += l12;
        l12 = l3 + 0x2000000L >> 26;
        l3 -= l12 << 26;
        l4 += l12;
        l12 = l4 + 0x2000000L >> 26;
        l4 -= l12 << 26;
        l5 += l12;
        l12 = l5 + 0x2000000L >> 26;
        l5 -= l12 << 26;
        l6 += l12;
        l12 = l6 + 0x2000000L >> 26;
        l6 -= l12 << 26;
        l7 += l12;
        l12 = l7 + 0x2000000L >> 26;
        l7 -= l12 << 26;
        l8 += l12;
        l12 = l8 + 0x2000000L >> 26;
        l8 -= l12 << 26;
        l9 += l12;
        l12 = l9 + 0x2000000L >> 26;
        l9 -= l12 << 26;
        l10 += l12;
        lArray[0] = l;
        lArray[1] = l2;
        lArray[2] = l3;
        lArray[3] = l4;
        lArray[4] = l5;
        lArray[5] = l6;
        lArray[6] = l7;
        lArray[7] = l8;
        lArray[8] = l9;
        lArray[9] = l10;
    }

    @Override
    protected void mult(long[] lArray, long[] lArray2, long[] lArray3) {
        long l = lArray[0] * lArray2[0];
        long l2 = lArray[0] * lArray2[1] + lArray[1] * lArray2[0];
        long l3 = lArray[0] * lArray2[2] + lArray[1] * lArray2[1] + lArray[2] * lArray2[0];
        long l4 = lArray[0] * lArray2[3] + lArray[1] * lArray2[2] + lArray[2] * lArray2[1] + lArray[3] * lArray2[0];
        long l5 = lArray[0] * lArray2[4] + lArray[1] * lArray2[3] + lArray[2] * lArray2[2] + lArray[3] * lArray2[1] + lArray[4] * lArray2[0];
        long l6 = lArray[0] * lArray2[5] + lArray[1] * lArray2[4] + lArray[2] * lArray2[3] + lArray[3] * lArray2[2] + lArray[4] * lArray2[1] + lArray[5] * lArray2[0];
        long l7 = lArray[0] * lArray2[6] + lArray[1] * lArray2[5] + lArray[2] * lArray2[4] + lArray[3] * lArray2[3] + lArray[4] * lArray2[2] + lArray[5] * lArray2[1] + lArray[6] * lArray2[0];
        long l8 = lArray[0] * lArray2[7] + lArray[1] * lArray2[6] + lArray[2] * lArray2[5] + lArray[3] * lArray2[4] + lArray[4] * lArray2[3] + lArray[5] * lArray2[2] + lArray[6] * lArray2[1] + lArray[7] * lArray2[0];
        long l9 = lArray[0] * lArray2[8] + lArray[1] * lArray2[7] + lArray[2] * lArray2[6] + lArray[3] * lArray2[5] + lArray[4] * lArray2[4] + lArray[5] * lArray2[3] + lArray[6] * lArray2[2] + lArray[7] * lArray2[1] + lArray[8] * lArray2[0];
        long l10 = lArray[0] * lArray2[9] + lArray[1] * lArray2[8] + lArray[2] * lArray2[7] + lArray[3] * lArray2[6] + lArray[4] * lArray2[5] + lArray[5] * lArray2[4] + lArray[6] * lArray2[3] + lArray[7] * lArray2[2] + lArray[8] * lArray2[1] + lArray[9] * lArray2[0];
        long l11 = lArray[1] * lArray2[9] + lArray[2] * lArray2[8] + lArray[3] * lArray2[7] + lArray[4] * lArray2[6] + lArray[5] * lArray2[5] + lArray[6] * lArray2[4] + lArray[7] * lArray2[3] + lArray[8] * lArray2[2] + lArray[9] * lArray2[1];
        long l12 = lArray[2] * lArray2[9] + lArray[3] * lArray2[8] + lArray[4] * lArray2[7] + lArray[5] * lArray2[6] + lArray[6] * lArray2[5] + lArray[7] * lArray2[4] + lArray[8] * lArray2[3] + lArray[9] * lArray2[2];
        long l13 = lArray[3] * lArray2[9] + lArray[4] * lArray2[8] + lArray[5] * lArray2[7] + lArray[6] * lArray2[6] + lArray[7] * lArray2[5] + lArray[8] * lArray2[4] + lArray[9] * lArray2[3];
        long l14 = lArray[4] * lArray2[9] + lArray[5] * lArray2[8] + lArray[6] * lArray2[7] + lArray[7] * lArray2[6] + lArray[8] * lArray2[5] + lArray[9] * lArray2[4];
        long l15 = lArray[5] * lArray2[9] + lArray[6] * lArray2[8] + lArray[7] * lArray2[7] + lArray[8] * lArray2[6] + lArray[9] * lArray2[5];
        long l16 = lArray[6] * lArray2[9] + lArray[7] * lArray2[8] + lArray[8] * lArray2[7] + lArray[9] * lArray2[6];
        long l17 = lArray[7] * lArray2[9] + lArray[8] * lArray2[8] + lArray[9] * lArray2[7];
        long l18 = lArray[8] * lArray2[9] + lArray[9] * lArray2[8];
        long l19 = lArray[9] * lArray2[9];
        this.carryReduce(lArray3, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19);
    }

    @Override
    protected void reduce(long[] lArray) {
        this.carryReduce(lArray, lArray[0], lArray[1], lArray[2], lArray[3], lArray[4], lArray[5], lArray[6], lArray[7], lArray[8], lArray[9]);
    }

    @Override
    protected void square(long[] lArray, long[] lArray2) {
        long l = lArray[0] * lArray[0];
        long l2 = 2L * (lArray[0] * lArray[1]);
        long l3 = 2L * (lArray[0] * lArray[2]) + lArray[1] * lArray[1];
        long l4 = 2L * (lArray[0] * lArray[3] + lArray[1] * lArray[2]);
        long l5 = 2L * (lArray[0] * lArray[4] + lArray[1] * lArray[3]) + lArray[2] * lArray[2];
        long l6 = 2L * (lArray[0] * lArray[5] + lArray[1] * lArray[4] + lArray[2] * lArray[3]);
        long l7 = 2L * (lArray[0] * lArray[6] + lArray[1] * lArray[5] + lArray[2] * lArray[4]) + lArray[3] * lArray[3];
        long l8 = 2L * (lArray[0] * lArray[7] + lArray[1] * lArray[6] + lArray[2] * lArray[5] + lArray[3] * lArray[4]);
        long l9 = 2L * (lArray[0] * lArray[8] + lArray[1] * lArray[7] + lArray[2] * lArray[6] + lArray[3] * lArray[5]) + lArray[4] * lArray[4];
        long l10 = 2L * (lArray[0] * lArray[9] + lArray[1] * lArray[8] + lArray[2] * lArray[7] + lArray[3] * lArray[6] + lArray[4] * lArray[5]);
        long l11 = 2L * (lArray[1] * lArray[9] + lArray[2] * lArray[8] + lArray[3] * lArray[7] + lArray[4] * lArray[6]) + lArray[5] * lArray[5];
        long l12 = 2L * (lArray[2] * lArray[9] + lArray[3] * lArray[8] + lArray[4] * lArray[7] + lArray[5] * lArray[6]);
        long l13 = 2L * (lArray[3] * lArray[9] + lArray[4] * lArray[8] + lArray[5] * lArray[7]) + lArray[6] * lArray[6];
        long l14 = 2L * (lArray[4] * lArray[9] + lArray[5] * lArray[8] + lArray[6] * lArray[7]);
        long l15 = 2L * (lArray[5] * lArray[9] + lArray[6] * lArray[8]) + lArray[7] * lArray[7];
        long l16 = 2L * (lArray[6] * lArray[9] + lArray[7] * lArray[8]);
        long l17 = 2L * (lArray[7] * lArray[9]) + lArray[8] * lArray[8];
        long l18 = 2L * (lArray[8] * lArray[9]);
        long l19 = lArray[9] * lArray[9];
        this.carryReduce(lArray2, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19);
    }
}

