/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.util.HashMap;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;

public class JRTableModelDataSource
implements JRRewindableDataSource {
    public static final String EXCEPTION_MESSAGE_KEY_UNKNOWN_COLUMN_NAME = "data.table.model.unknown.column.name";
    private TableModel tableModel;
    private int index = -1;
    private HashMap<String, Integer> columnNames = new HashMap();

    public JRTableModelDataSource(TableModel model) {
        this.tableModel = model;
        if (this.tableModel != null) {
            for (int i = 0; i < this.tableModel.getColumnCount(); ++i) {
                this.columnNames.put(this.tableModel.getColumnName(i), i);
            }
        }
    }

    @Override
    public boolean next() {
        ++this.index;
        if (this.tableModel != null) {
            return this.index < this.tableModel.getRowCount();
        }
        return false;
    }

    @Override
    public Object getFieldValue(JRField jrField) throws JRException {
        String fieldName = jrField.getName();
        Integer columnIndex = this.columnNames.get(fieldName);
        if (columnIndex != null) {
            return this.tableModel.getValueAt(this.index, columnIndex);
        }
        if (fieldName.startsWith("COLUMN_")) {
            return this.tableModel.getValueAt(this.index, Integer.parseInt(fieldName.substring(7)));
        }
        throw new JRException(EXCEPTION_MESSAGE_KEY_UNKNOWN_COLUMN_NAME, new Object[]{fieldName});
    }

    @Override
    public void moveFirst() {
        this.index = -1;
    }
}

