/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRSection;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.fill.ElementRange;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillSection;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import net.sf.jasperreports.engine.type.FooterPositionEnum;

public class JRFillGroup
implements JRGroup {
    protected JRGroup parent;
    private JRFillSection groupHeaderSection;
    private JRFillSection groupFooterSection;
    private JRVariable countVariable;
    private boolean startNewColumn;
    private boolean startNewPage;
    private boolean resetPageNumber;
    private boolean hasChanged = true;
    private boolean isTopLevelChange;
    private boolean isHeaderPrinted;
    private boolean isFooterPrinted = true;
    private int detailsCount;
    private ElementRange keepTogetherElementRange;

    public JRFillGroup(JRGroup group, JRFillObjectFactory factory) {
        factory.put(group, this);
        this.parent = group;
        JRBaseFiller filler = factory.getFiller();
        if (filler != null) {
            String reportName = filler.getBandReportParent() == null ? null : filler.getBandReportParent().getReportName();
            this.groupHeaderSection = factory.getSection(group.getGroupHeaderSection());
            if (this.groupHeaderSection != factory.getFiller().missingFillSection) {
                this.groupHeaderSection.setOrigin(new JROrigin(reportName, group.getName(), BandTypeEnum.GROUP_HEADER));
            }
            this.groupFooterSection = factory.getSection(group.getGroupFooterSection());
            if (this.groupFooterSection != factory.getFiller().missingFillSection) {
                this.groupFooterSection.setOrigin(new JROrigin(reportName, group.getName(), BandTypeEnum.GROUP_FOOTER));
            }
        }
        this.countVariable = factory.getVariable(group.getCountVariable());
        this.startNewColumn = this.parent.isStartNewColumn();
        this.startNewPage = this.parent.isStartNewPage();
        this.resetPageNumber = this.parent.isResetPageNumber();
    }

    @Override
    public String getName() {
        return this.parent.getName();
    }

    @Override
    public JRExpression getExpression() {
        return this.parent.getExpression();
    }

    @Override
    public boolean isStartNewColumn() {
        return this.startNewColumn;
    }

    @Override
    public void setStartNewColumn(boolean isStart) {
        this.startNewColumn = isStart;
    }

    @Override
    public boolean isStartNewPage() {
        return this.startNewPage;
    }

    @Override
    public void setStartNewPage(boolean isStart) {
        this.startNewPage = isStart;
    }

    @Override
    public boolean isResetPageNumber() {
        return this.resetPageNumber;
    }

    @Override
    public void setResetPageNumber(boolean isReset) {
        this.resetPageNumber = isReset;
    }

    @Override
    public boolean isReprintHeaderOnEachPage() {
        return this.parent.isReprintHeaderOnEachPage();
    }

    @Override
    public void setReprintHeaderOnEachPage(boolean isReprint) {
    }

    @Override
    public boolean isReprintHeaderOnEachColumn() {
        return this.parent.isReprintHeaderOnEachColumn();
    }

    @Override
    public void setReprintHeaderOnEachColumn(boolean isReprint) {
    }

    @Override
    public int getMinHeightToStartNewPage() {
        return this.parent.getMinHeightToStartNewPage();
    }

    @Override
    public void setMinHeightToStartNewPage(int minHeight) {
    }

    @Override
    public int getMinDetailsToStartFromTop() {
        return this.parent.getMinDetailsToStartFromTop();
    }

    @Override
    public void setMinDetailsToStartFromTop(int minDetails) {
    }

    @Override
    public FooterPositionEnum getFooterPositionValue() {
        return this.parent.getFooterPositionValue();
    }

    @Override
    public void setFooterPosition(FooterPositionEnum footerPosition) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isKeepTogether() {
        return this.parent.isKeepTogether();
    }

    @Override
    public void setKeepTogether(boolean keepTogether) {
    }

    @Override
    public boolean isPreventOrphanFooter() {
        return this.parent.isPreventOrphanFooter();
    }

    @Override
    public void setPreventOrphanFooter(boolean preventOrphanFooter) {
    }

    @Override
    public JRSection getGroupHeaderSection() {
        return this.groupHeaderSection;
    }

    @Override
    public JRSection getGroupFooterSection() {
        return this.groupFooterSection;
    }

    @Override
    public JRVariable getCountVariable() {
        return this.countVariable;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void setHasChanged(boolean hasChanged) {
        this.hasChanged = hasChanged;
    }

    public boolean isTopLevelChange() {
        return this.isTopLevelChange;
    }

    public void setTopLevelChange(boolean isTopLevelChange) {
        this.isTopLevelChange = isTopLevelChange;
    }

    public boolean isHeaderPrinted() {
        return this.isHeaderPrinted;
    }

    public void setHeaderPrinted(boolean isHeaderPrinted) {
        this.isHeaderPrinted = isHeaderPrinted;
    }

    public boolean isFooterPrinted() {
        return this.isFooterPrinted;
    }

    public void setFooterPrinted(boolean isFooterPrinted) {
        this.isFooterPrinted = isFooterPrinted;
    }

    public ElementRange getKeepTogetherElementRange() {
        return this.keepTogetherElementRange;
    }

    public void setKeepTogetherElementRange(ElementRange keepTogetherElementRange) {
        this.keepTogetherElementRange = keepTogetherElementRange;
    }

    protected void incrementDetailsCount() {
        ++this.detailsCount;
    }

    protected void resetDetailsCount() {
        this.detailsCount = 0;
    }

    protected boolean hasMinDetails() {
        return this.hasMinDetails(0);
    }

    protected boolean hasMinDetails(int detailsToMove) {
        return this.getMinDetailsToStartFromTop() == 0 || this.getMinDetailsToStartFromTop() <= this.detailsCount - detailsToMove;
    }

    protected int getDetailsCount() {
        return this.detailsCount;
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }
}

