/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRClassLoader;

public final class ClassUtils {
    public static final String EXCEPTION_MESSAGE_KEY_CLASS_INSTANCE_ERROR = "util.class.instance.error";
    public static final String EXCEPTION_MESSAGE_KEY_CLASS_LOADING_ERROR = "util.class.loading.error";
    public static final String EXCEPTION_MESSAGE_KEY_CLASS_UNEXPECTED_TYPE = "util.class.unexpected.type";

    public static final Object instantiateClass(String className, Class<?> expectedType) {
        try {
            Class<?> clazz = JRClassLoader.loadClassForName(className);
            if (!expectedType.isAssignableFrom(clazz)) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_CLASS_UNEXPECTED_TYPE, new Object[]{className, expectedType.getName()});
            }
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_CLASS_LOADING_ERROR, new Object[]{className}, e);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_CLASS_INSTANCE_ERROR, new Object[]{className}, e);
        }
    }

    public static List<Class<?>> getInterfaces(Class<?> clazz) {
        ArrayList interfaces = new ArrayList();
        while (clazz != null) {
            interfaces.addAll(Arrays.asList(clazz.getInterfaces()));
            clazz = clazz.getSuperclass();
        }
        return interfaces;
    }

    private ClassUtils() {
    }
}

