/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.BasicStroke;
import java.awt.Stroke;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.type.PenEnum;

public final class JRPenUtil {
    public static void setLinePenFromPen(PenEnum pen, JRPen linePen) {
        if (pen != null) {
            switch (pen) {
                case THIN: {
                    linePen.setLineWidth(Float.valueOf(0.5f));
                    linePen.setLineStyle(LineStyleEnum.SOLID);
                    break;
                }
                case ONE_POINT: {
                    linePen.setLineWidth(Float.valueOf(1.0f));
                    linePen.setLineStyle(LineStyleEnum.SOLID);
                    break;
                }
                case TWO_POINT: {
                    linePen.setLineWidth(Float.valueOf(2.0f));
                    linePen.setLineStyle(LineStyleEnum.SOLID);
                    break;
                }
                case FOUR_POINT: {
                    linePen.setLineWidth(Float.valueOf(4.0f));
                    linePen.setLineStyle(LineStyleEnum.SOLID);
                    break;
                }
                case DOTTED: {
                    linePen.setLineWidth(Float.valueOf(1.0f));
                    linePen.setLineStyle(LineStyleEnum.DASHED);
                    break;
                }
                case NONE: {
                    linePen.setLineWidth(Float.valueOf(0.0f));
                    linePen.setLineStyle(LineStyleEnum.SOLID);
                }
            }
        }
    }

    public static Stroke getStroke(JRPen pen, int lineCap) {
        float lineWidth = pen.getLineWidth().floatValue();
        if (lineWidth > 0.0f) {
            LineStyleEnum lineStyle = pen.getLineStyleValue();
            switch (lineStyle) {
                case DOUBLE: {
                    return new BasicStroke(lineWidth / 3.0f, lineCap, 0);
                }
                case DOTTED: {
                    switch (lineCap) {
                        case 2: {
                            return new BasicStroke(lineWidth, lineCap, 0, 10.0f, new float[]{0.0f, 2.0f * lineWidth}, 0.0f);
                        }
                        case 0: {
                            return new BasicStroke(lineWidth, lineCap, 0, 10.0f, new float[]{lineWidth, lineWidth}, 0.0f);
                        }
                    }
                }
                case DASHED: {
                    switch (lineCap) {
                        case 2: {
                            return new BasicStroke(lineWidth, lineCap, 0, 10.0f, new float[]{4.0f * lineWidth, 4.0f * lineWidth}, 0.0f);
                        }
                        case 0: {
                            return new BasicStroke(lineWidth, lineCap, 0, 10.0f, new float[]{5.0f * lineWidth, 3.0f * lineWidth}, 0.0f);
                        }
                    }
                }
            }
            return new BasicStroke(lineWidth, lineCap, 0);
        }
        return null;
    }

    private JRPenUtil() {
    }
}

