/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util.xml;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRSingletonCache;
import net.sf.jasperreports.engine.util.xml.JRXPathExecuter;
import net.sf.jasperreports.engine.util.xml.JRXPathExecuterFactory;

public final class JRXPathExecuterUtils {
    public static final String EXCEPTION_MESSAGE_KEY_XPATH_EXECUTER_FACTORY_NOT_FOUND = "util.xml.xpath.executer.factory.property.not.found";
    public static final String PROPERTY_XPATH_EXECUTER_FACTORY = "net.sf.jasperreports.xpath.executer.factory";
    private static final JRSingletonCache<JRXPathExecuterFactory> cache = new JRSingletonCache<JRXPathExecuterFactory>(JRXPathExecuterFactory.class);

    public static JRXPathExecuterFactory getXPathExecuterFactory(JasperReportsContext jasperReportsContext) throws JRException {
        String factoryClassName = JRPropertiesUtil.getInstance(jasperReportsContext).getProperty(PROPERTY_XPATH_EXECUTER_FACTORY);
        if (factoryClassName == null) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_XPATH_EXECUTER_FACTORY_NOT_FOUND, new Object[]{PROPERTY_XPATH_EXECUTER_FACTORY});
        }
        return cache.getCachedInstance(factoryClassName);
    }

    public static JRXPathExecuter getXPathExecuter(JasperReportsContext jasperReportsContext) throws JRException {
        JRXPathExecuterFactory executerFactory = JRXPathExecuterUtils.getXPathExecuterFactory(jasperReportsContext);
        return executerFactory.getXPathExecuter();
    }

    private JRXPathExecuterUtils() {
    }
}

