/*
 * Decompiled with CFR 0.152.
 */
package com.demo;

import com.notification.NotificationBuilder;
import com.notification.types.BorderLayoutNotification;
import com.theme.TextTheme;
import com.theme.ThemePackage;
import com.theme.WindowTheme;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class CustomNotification
extends BorderLayoutNotification {
    private JLabel m_label = new JLabel();
    private JButton m_button = new JButton("Click me!");
    private JProgressBar m_progress = new JProgressBar();
    private TextTheme m_theme;

    public CustomNotification() {
        this.m_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomNotification.this.removeComponent(CustomNotification.this.m_button);
                CustomNotification.this.addComponent(CustomNotification.this.m_progress, "South");
                final Timer timer = new Timer(100, null);
                timer.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CustomNotification.this.m_progress.setValue(CustomNotification.this.m_progress.getValue() + 1);
                        CustomNotification.this.m_progress.repaint();
                        if (CustomNotification.this.m_progress.getValue() == 100) {
                            timer.stop();
                            CustomNotification.this.hide();
                        }
                    }
                });
                timer.start();
            }
        });
        this.addComponent(this.m_label, "Center");
        this.addComponent(this.m_button, "South");
    }

    public void setTextTheme(TextTheme theme) {
        this.m_label.setFont(theme.title);
        this.m_label.setForeground(theme.titleColor);
        this.m_button.setFont(theme.subtitle);
        this.m_button.setForeground(theme.subtitleColor);
        this.m_theme = theme;
    }

    public String getText() {
        return this.m_label.getText();
    }

    public void setText(String text) {
        this.m_label.setText(text);
    }

    @Override
    public void setWindowTheme(WindowTheme theme) {
        super.setWindowTheme(theme);
        if (this.m_theme != null) {
            this.m_label.setForeground(this.m_theme.titleColor);
            this.m_button.setForeground(this.m_theme.subtitleColor);
        }
    }

    public static class CustomBuilder
    implements NotificationBuilder<CustomNotification> {
        @Override
        public CustomNotification buildNotification(ThemePackage pack, Object ... args) {
            CustomNotification note = new CustomNotification();
            note.setWindowTheme(pack.getTheme(WindowTheme.class));
            note.setTextTheme(pack.getTheme(TextTheme.class));
            if (args.length > 0) {
                note.setText((String)args[0]);
            } else {
                note.setText("No text supplied");
            }
            return note;
        }
    }
}

