/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import java.util.UUID;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRPart;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVisitable;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.part.PartComponent;
import net.sf.jasperreports.engine.part.PartComponentManager;
import net.sf.jasperreports.engine.part.PartComponentsEnvironment;
import net.sf.jasperreports.engine.part.PartEvaluationTime;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRBasePart
implements JRPart,
Serializable,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    protected UUID uuid;
    private JRPropertiesMap propertiesMap;
    protected JRExpression printWhenExpression;
    protected JRExpression partNameExpression;
    protected ComponentKey componentKey;
    protected PartComponent component;
    protected PartEvaluationTime evaluationTime;
    private transient JRPropertyChangeSupport eventSupport;

    protected JRBasePart() {
    }

    public JRBasePart(JRPart part, JRBaseObjectFactory factory) {
        factory.put(part, this);
        this.uuid = part.getUUID();
        this.propertiesMap = JRPropertiesMap.getPropertiesClone(part);
        this.printWhenExpression = factory.getExpression(part.getPrintWhenExpression());
        this.partNameExpression = factory.getExpression(part.getPartNameExpression());
        this.evaluationTime = part.getEvaluationTime();
        this.componentKey = part.getComponentKey();
        PartComponentManager manager = PartComponentsEnvironment.getInstance(DefaultJasperReportsContext.getInstance()).getManager(this.componentKey);
        this.component = manager.getComponentCompiler(DefaultJasperReportsContext.getInstance()).toCompiledComponent(part.getComponent(), factory);
        if (this.component instanceof JRVisitable) {
            ((JRVisitable)((Object)this.component)).visit(factory);
        }
    }

    @Override
    public UUID getUUID() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
        }
        return this.uuid;
    }

    @Override
    public PartComponent getComponent() {
        return this.component;
    }

    @Override
    public ComponentKey getComponentKey() {
        return this.componentKey;
    }

    @Override
    public PartEvaluationTime getEvaluationTime() {
        return this.evaluationTime;
    }

    @Override
    public JRExpression getPrintWhenExpression() {
        return this.printWhenExpression;
    }

    @Override
    public JRExpression getPartNameExpression() {
        return this.partNameExpression;
    }

    @Override
    public boolean hasProperties() {
        return this.propertiesMap != null && this.propertiesMap.hasProperties();
    }

    @Override
    public JRPropertiesMap getPropertiesMap() {
        if (this.propertiesMap == null) {
            this.propertiesMap = new JRPropertiesMap();
        }
        return this.propertiesMap;
    }

    @Override
    public JRPropertiesHolder getParentProperties() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        JRBasePart jRBasePart = this;
        synchronized (jRBasePart) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    @Override
    public Object clone() {
        JRBasePart clone = null;
        try {
            clone = (JRBasePart)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.printWhenExpression = JRCloneUtils.nullSafeClone(this.printWhenExpression);
        clone.partNameExpression = JRCloneUtils.nullSafeClone(this.partNameExpression);
        clone.propertiesMap = JRPropertiesMap.getPropertiesClone(this);
        clone.uuid = null;
        clone.eventSupport = null;
        return clone;
    }
}

