/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JRXlsxDataSource;
import net.sf.jasperreports.engine.query.AbstractXlsQueryExecuter;
import net.sf.jasperreports.engine.query.QueryExecutionContext;
import net.sf.jasperreports.engine.query.SimpleQueryExecutionContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Workbook;

public class JRXlsxQueryExecuter
extends AbstractXlsQueryExecuter {
    private static final Log log = LogFactory.getLog(JRXlsxQueryExecuter.class);
    private JRXlsxDataSource datasource;

    protected JRXlsxQueryExecuter(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        this(SimpleQueryExecutionContext.of(jasperReportsContext), dataset, parametersMap);
    }

    protected JRXlsxQueryExecuter(QueryExecutionContext context, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        super(context, dataset, parametersMap);
    }

    @Override
    public JRDataSource createDatasource() throws JRException {
        try {
            Workbook workbook = (Workbook)this.getParameterValue("XLSX_WORKBOOK");
            if (workbook == null) {
                workbook = (Workbook)this.getParameterValue("XLS_WORKBOOK", true);
            }
            if (workbook != null) {
                this.datasource = new JRXlsxDataSource(workbook);
            } else {
                InputStream xlsxInputStream = (InputStream)this.getParameterValue("XLSX_INPUT_STREAM");
                if (xlsxInputStream == null) {
                    xlsxInputStream = (InputStream)this.getParameterValue("XLS_INPUT_STREAM", true);
                }
                if (xlsxInputStream != null) {
                    this.datasource = new JRXlsxDataSource(xlsxInputStream);
                } else {
                    File xlsxFile = (File)this.getParameterValue("XLSX_FILE");
                    if (xlsxFile == null) {
                        xlsxFile = (File)this.getParameterValue("XLS_FILE", true);
                    }
                    if (xlsxFile != null) {
                        this.datasource = new JRXlsxDataSource(xlsxFile);
                    } else {
                        String xlsxSource = this.getStringParameterOrProperty("net.sf.jasperreports.xlsx.source");
                        if (xlsxSource == null) {
                            xlsxSource = this.getStringParameterOrProperty("net.sf.jasperreports.xls.source");
                        }
                        if (xlsxSource != null) {
                            this.datasource = new JRXlsxDataSource(this.getRepositoryContext(), xlsxSource);
                        } else if (log.isWarnEnabled()) {
                            log.warn((Object)"No XLS source was provided.");
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            throw new JRException(e);
        }
        if (this.datasource != null) {
            this.initDatasource(this.datasource);
        }
        return this.datasource;
    }
}

