/*
 * Decompiled with CFR 0.152.
 */
package jnasmartcardio;

import com.sun.jna.Platform;
import com.sun.jna.Structure;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardNotPresentException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import javax.smartcardio.TerminalFactorySpi;
import jnasmartcardio.Winscard;
import jnasmartcardio.WinscardConstants;

public class Smartcardio
extends Provider {
    private static final long serialVersionUID = 1L;
    static final int MAX_ATR_SIZE = 33;
    public static final String PROVIDER_NAME = "JNA2PCSC";
    public static final int SCARD_S_SUCCESS = 0;
    public static final int SCARD_E_NO_READERS_AVAILABLE = -2146435026;
    public static final int SCARD_E_READER_UNAVAILABLE = -2146435049;
    public static final int SCARD_E_NO_SMARTCARD = -2146435060;

    public Smartcardio() {
        super(PROVIDER_NAME, 0.2, "JNA-to-PCSC Provider");
        this.put("TerminalFactory.PC/SC", JnaTerminalFactorySpi.class.getName());
    }

    private static List<String> pcsc_multi2jstring(byte[] multiString, Charset charset) {
        ArrayList<String> r = new ArrayList<String>();
        int from = 0;
        for (int to = 0; to < multiString.length; ++to) {
            if (multiString[to] != 0) continue;
            if (from == to) {
                return r;
            }
            byte[] bytes = Arrays.copyOfRange(multiString, from, to);
            r.add(new String(bytes, charset));
            from = to + 1;
        }
        throw new IllegalArgumentException("Multistring must be end with a null-terminated empty string.");
    }

    private static List<String> pcsc_multi2jstring(byte[] multiString) {
        return Smartcardio.pcsc_multi2jstring(multiString, Charset.forName("UTF-8"));
    }

    private static void check(String message, Winscard.Dword code) throws JnaPCSCException {
        Smartcardio.check(message, code.longValue());
    }

    private static void check(String message, long code) throws JnaPCSCException {
        if (code == 0L) {
            return;
        }
        int icode = (int)code;
        String codeName = WinscardConstants.ERROR_TO_VARIABLE_NAME.get(icode);
        String codeDescription = WinscardConstants.ERROR_TO_DESCRIPTION.get(icode);
        throw new JnaPCSCException(code, String.format("%s got response 0x%x (%s: %s)", message, icode, codeName, codeDescription));
    }

    public static class JnaCardException
    extends CardException {
        private static final long serialVersionUID = 1L;
        public final int sw;

        public JnaCardException(int sw, String message) {
            this(sw, message, null);
        }

        public JnaCardException(int sw, String message, Throwable cause) {
            super(message, cause);
            this.sw = sw;
        }
    }

    public static class JnaCardNotPresentException
    extends CardNotPresentException {
        private static final long serialVersionUID = 1L;
        public final long code;

        public JnaCardNotPresentException(long code, String message) {
            super(message);
            this.code = code;
        }
    }

    public static class EstablishContextException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public EstablishContextException(JnaPCSCException cause) {
            super(cause);
        }

        @Override
        public JnaPCSCException getCause() {
            return (JnaPCSCException)super.getCause();
        }
    }

    public static class JnaPCSCException
    extends CardException {
        private static final long serialVersionUID = 1L;
        public final long code;

        public JnaPCSCException(String message) {
            this(0L, message, null);
        }

        public JnaPCSCException(Throwable cause) {
            this(0L, null, cause);
        }

        public JnaPCSCException(long code, String message) {
            this(code, message, null);
        }

        public JnaPCSCException(long code, String message, Throwable cause) {
            super(message, cause);
            this.code = code;
        }
    }

    public static class JnaCardChannel
    extends CardChannel {
        private final JnaCard card;
        private final int channel;
        private boolean isClosed;

        public JnaCardChannel(JnaCard card, int channel) {
            this.card = card;
            this.channel = channel;
        }

        @Override
        public void close() throws CardException {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            if (this.channel != 0) {
                ByteBuffer command = ByteBuffer.wrap(new CommandAPDU(0, 112, 128, this.channel).getBytes());
                ByteBuffer response = ByteBuffer.allocate(2);
                this.transmitRaw(command, response);
                response.rewind();
                int sw = 0xFFFF & response.getShort();
                if (sw != 36864) {
                    throw new JnaCardException(sw, "Could not close channel.");
                }
            } else {
                throw new IllegalStateException("Basic channel can not be closed");
            }
        }

        @Override
        public Card getCard() {
            return this.card;
        }

        @Override
        public int getChannelNumber() {
            return this.channel;
        }

        @Override
        public ResponseAPDU transmit(CommandAPDU command) throws CardException {
            if (command == null) {
                throw new IllegalArgumentException("command is null");
            }
            byte[] commandCopy = command.getBytes();
            ByteBuffer response = this.transmitImpl(commandCopy, null);
            ResponseAPDU responseApdu = JnaCardChannel.convertResponse(response);
            return responseApdu;
        }

        @Override
        public int transmit(ByteBuffer command, ByteBuffer response) throws CardException {
            if (command == null) {
                throw new IllegalArgumentException("command is null");
            }
            if (response == null) {
                throw new IllegalArgumentException("response is null");
            }
            byte[] commandCopy = new byte[command.remaining()];
            command.get(commandCopy);
            int startPosition = response.position();
            this.transmitImpl(commandCopy, response);
            int endPosition = response.position();
            return endPosition - startPosition;
        }

        private boolean isExtendedApdu(byte[] commandApdu) {
            return commandApdu.length >= 7 && commandApdu[4] == 0;
        }

        private ByteBuffer transmitImpl(byte[] command, ByteBuffer response) throws CardException, JnaPCSCException {
            if (this.card.protocol == 1 && this.isExtendedApdu(command)) {
                throw new CardException("Extended APDU requires T=1");
            }
            command[0] = JnaCardChannel.getClassByte(command[0], this.getChannelNumber());
            ByteBuffer commandBuffer = ByteBuffer.wrap(command);
            if (response == null) {
                response = ByteBuffer.allocate(8192);
            }
            for (int i = 0; i < 8; ++i) {
                int posBeforeTransmit = response.position();
                this.transmitRaw(commandBuffer, response);
                response.position(response.position() - 2);
                byte sw1 = response.get();
                byte sw2 = response.get();
                if (108 == sw1) {
                    command[command.length - 1] = sw2;
                    response.position(posBeforeTransmit);
                    commandBuffer.rewind();
                    continue;
                }
                if (97 != sw1) break;
                command[1] = -64;
                command[2] = 0;
                command[3] = 0;
                command[4] = sw2;
                commandBuffer.position(0);
                commandBuffer.limit(5);
                response.position(response.position() - 2);
            }
            return response;
        }

        static byte getClassByte(byte origCla, int channelNumber) {
            int cla;
            if ((0x80 & origCla) != 0) {
                return origCla;
            }
            if (0 <= channelNumber && channelNumber <= 3) {
                cla = origCla & 0x1C | channelNumber;
            } else if (4 <= channelNumber && channelNumber <= 19) {
                int channelBits = channelNumber - 4;
                cla = origCla & 0x30 | channelBits | 0x40;
            } else {
                throw new IllegalStateException("Bad channel number; expected 0-19; got " + channelNumber);
            }
            return (byte)cla;
        }

        private static ResponseAPDU convertResponse(ByteBuffer responseBuf) {
            byte[] responseBytes = new byte[responseBuf.position()];
            responseBuf.rewind();
            responseBuf.get(responseBytes);
            return new ResponseAPDU(responseBytes);
        }

        private int transmitRaw(ByteBuffer command, ByteBuffer response) throws JnaPCSCException {
            Winscard.ScardIoRequest pioSendPci = new Winscard.ScardIoRequest();
            pioSendPci.dwProtocol = new Winscard.Dword(this.card.protocol);
            pioSendPci.cbPciLength = new Winscard.Dword(pioSendPci.size());
            Winscard.DwordByReference recvLength = new Winscard.DwordByReference(new Winscard.Dword(response.remaining()));
            Smartcardio.check("SCardTransmit", ((JnaCard)this.card).libInfo.lib.SCardTransmit(this.card.scardHandle, pioSendPci, command, new Winscard.Dword(command.remaining()), null, response, recvLength));
            int recvLengthInt = recvLength.getValue().intValue();
            assert (recvLengthInt >= 0);
            command.position(command.limit());
            int newPosition = response.position() + recvLengthInt;
            response.position(newPosition);
            return recvLengthInt;
        }

        public String toString() {
            return String.format("%s{card=%s, channel=%d}", this.getClass().getSimpleName(), this.card, this.channel);
        }
    }

    public static class JnaCard
    extends Card {
        private final Winscard.WinscardLibInfo libInfo;
        private final CardTerminal cardTerminal;
        private final Winscard.SCardHandle scardHandle;
        private final ATR atr;
        private final int protocol;
        public static final int SCARD_LEAVE_CARD = 0;
        public static final int SCARD_RESET_CARD = 1;
        public static final int SCARD_UNPOWER_CARD = 2;
        public static final int SCARD_EJECT_CARD = 3;

        public JnaCard(Winscard.WinscardLibInfo libInfo, JnaCardTerminal cardTerminal, Winscard.SCardHandle scardHandle, ATR atr, int protocol) {
            this.libInfo = libInfo;
            this.cardTerminal = cardTerminal;
            this.scardHandle = scardHandle;
            this.atr = atr;
            this.protocol = protocol;
            this.getProtocol();
        }

        @Override
        public void beginExclusive() throws CardException {
            Smartcardio.check("SCardBeginTransaction", this.libInfo.lib.SCardBeginTransaction(this.scardHandle));
        }

        @Override
        public void endExclusive() throws CardException {
            Smartcardio.check("SCardEndTransaction", this.libInfo.lib.SCardEndTransaction(this.scardHandle, new Winscard.Dword(0L)));
        }

        @Override
        public void disconnect(boolean reset) throws CardException {
            int dwDisposition = reset ? 1 : 0;
            Smartcardio.check("SCardDisconnect", this.libInfo.lib.SCardDisconnect(this.scardHandle, new Winscard.Dword(dwDisposition)));
        }

        @Override
        public ATR getATR() {
            return this.atr;
        }

        @Override
        public String getProtocol() {
            switch (this.protocol) {
                case 1: {
                    return "T=0";
                }
                case 2: {
                    return "T=1";
                }
            }
            return "DIRECT";
        }

        @Override
        public JnaCardChannel getBasicChannel() {
            return new JnaCardChannel(this, 0);
        }

        @Override
        public CardChannel openLogicalChannel() throws CardException {
            JnaCardChannel basicChannel = this.getBasicChannel();
            ResponseAPDU response = basicChannel.transmit(new CommandAPDU(0, 112, 0, 0, 1));
            int sw = response.getSW();
            if (36864 == sw) {
                byte[] body = response.getData();
                if (body.length == 1) {
                    int channel = 0xFF & body[0];
                    if (channel == 0 || channel > 19) {
                        throw new JnaCardException(sw, String.format("Expected manage channel response to contain channel number in 1-19; got %d", channel));
                    }
                    return new JnaCardChannel(this, channel);
                }
                throw new JnaCardException(sw, String.format("Expected body of length 1 in response to manage channel request; got %d", body.length));
            }
            throw new JnaCardException(sw, String.format("Error: sw=%04x in response to manage channel command.", sw));
        }

        @Override
        public byte[] transmitControlCommand(int controlCode, byte[] arg1) throws CardException {
            ByteBuffer receiveBuf = ByteBuffer.allocate(8192);
            Winscard.DwordByReference lpBytesReturned = new Winscard.DwordByReference();
            ByteBuffer arg1Wrapped = ByteBuffer.wrap(arg1);
            Smartcardio.check("SCardControl", this.libInfo.lib.SCardControl(this.scardHandle, new Winscard.Dword(controlCode), arg1Wrapped, new Winscard.Dword(arg1.length), receiveBuf, new Winscard.Dword(receiveBuf.remaining()), lpBytesReturned));
            int bytesReturned = lpBytesReturned.getValue().intValue();
            receiveBuf.limit(bytesReturned);
            byte[] r = new byte[bytesReturned];
            receiveBuf.get(r);
            return r;
        }

        public String toString() {
            return String.format("%s{scardHandle=%s}", new Object[]{this.getClass().getSimpleName(), this.scardHandle});
        }
    }

    public static class JnaCardTerminal
    extends CardTerminal {
        private final Winscard.WinscardLibInfo libInfo;
        private final JnaCardTerminals cardTerminals;
        private final String name;
        public static final int SCARD_SHARE_EXCLUSIVE = 1;
        public static final int SCARD_SHARE_SHARED = 2;
        public static final int SCARD_SHARE_DIRECT = 3;
        public static final int SCARD_PROTOCOL_T0 = 1;
        public static final int SCARD_PROTOCOL_T1 = 2;
        public static final int SCARD_PROTOCOL_ANY = 3;
        public static final int SCARD_UNKNOWN = 1;
        public static final int SCARD_ABSENT = 2;
        public static final int SCARD_PRESENT = 4;
        public static final int SCARD_SWALLOWED = 8;
        public static final int SCARD_POWERED = 16;
        public static final int SCARD_NEGOTIABLE = 32;
        public static final int SCARD_SPECIFIC = 64;

        public JnaCardTerminal(Winscard.WinscardLibInfo libInfo, JnaCardTerminals cardTerminals, String name) {
            this.libInfo = libInfo;
            this.cardTerminals = cardTerminals;
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Card connect(String protocol) throws CardException {
            int dwPreferredProtocols;
            int dwShareMode = 2;
            if ((protocol = protocol.toUpperCase()).startsWith("EXCLUSIVE;")) {
                dwShareMode = 1;
                protocol = protocol.substring("EXCLUSIVE;".length());
            }
            if ("T=0".equals(protocol)) {
                dwPreferredProtocols = 1;
            } else if ("T=1".equals(protocol)) {
                dwPreferredProtocols = 2;
            } else if ("*".equals(protocol)) {
                dwPreferredProtocols = 3;
            } else if ("DIRECT".equalsIgnoreCase(protocol)) {
                dwPreferredProtocols = 0;
                if (Platform.isMac()) {
                    dwPreferredProtocols = 3;
                }
                dwShareMode = 3;
            } else {
                throw new IllegalArgumentException("Protocol should be one of (prepended with EXCLUSIVE;) T=0, T=1, *, DIRECT. Got " + protocol);
            }
            Winscard.SCardHandleByReference phCard = new Winscard.SCardHandleByReference();
            Winscard.DwordByReference pdwActiveProtocol = new Winscard.DwordByReference();
            long err = this.libInfo.lib.SCardConnect(this.cardTerminals.scardContext, this.name, new Winscard.Dword(dwShareMode), new Winscard.Dword(dwPreferredProtocols), phCard, pdwActiveProtocol).longValue();
            switch ((int)err) {
                case 0: {
                    Winscard.SCardHandle scardHandle = phCard.getValue();
                    Winscard.DwordByReference readerLength = new Winscard.DwordByReference();
                    Winscard.DwordByReference currentState = new Winscard.DwordByReference();
                    Winscard.DwordByReference currentProtocol = new Winscard.DwordByReference();
                    ByteBuffer atrBuf = ByteBuffer.allocate(33);
                    Winscard.DwordByReference atrLength = new Winscard.DwordByReference(new Winscard.Dword(33L));
                    Smartcardio.check("SCardStatus", this.libInfo.lib.SCardStatus(scardHandle, null, readerLength, currentState, currentProtocol, atrBuf, atrLength));
                    int atrLengthInt = atrLength.getValue().intValue();
                    atrBuf.limit(atrLengthInt);
                    byte[] atrBytes = new byte[atrBuf.remaining()];
                    atrBuf.get(atrBytes);
                    ATR atr = new ATR(atrBytes);
                    int currentProtocolInt = currentProtocol.getValue().intValue();
                    return new JnaCard(this.libInfo, this, scardHandle, atr, currentProtocolInt);
                }
                case -2146434967: {
                    throw new JnaCardNotPresentException(err, "Card not present.");
                }
            }
            Smartcardio.check("SCardConnect", err);
            throw new RuntimeException("Should not reach here.");
        }

        @Override
        public boolean isCardPresent() throws CardException {
            Winscard.SCardReaderState[] rgReaderStates = new Winscard.SCardReaderState[1];
            new Winscard.SCardReaderState().toArray(rgReaderStates);
            rgReaderStates[0].szReader = this.name;
            Winscard.SCardReaderState readerState = rgReaderStates[0];
            Smartcardio.check("SCardGetStatusChange", this.libInfo.lib.SCardGetStatusChange(this.cardTerminals.scardContext, new Winscard.Dword(0L), rgReaderStates, new Winscard.Dword(rgReaderStates.length)));
            return 0 != (readerState.dwEventState.intValue() & 0x20);
        }

        private boolean waitHelper(long timeoutMs, boolean cardPresent) throws JnaPCSCException {
            if (timeoutMs < 0L) {
                throw new IllegalArgumentException("Negative timeout " + timeoutMs);
            }
            if (timeoutMs == 0L) {
                timeoutMs = -1L;
            }
            Winscard.SCardReaderState[] rgReaderStates = new Winscard.SCardReaderState[1];
            new Winscard.SCardReaderState().toArray(rgReaderStates);
            Winscard.SCardReaderState readerState = rgReaderStates[0];
            readerState.szReader = this.name;
            Smartcardio.check("SCardGetStatusChange", this.libInfo.lib.SCardGetStatusChange(this.cardTerminals.scardContext, new Winscard.Dword(0L), rgReaderStates, new Winscard.Dword(rgReaderStates.length)));
            int remainingTimeout = (int)timeoutMs;
            while (cardPresent != (0 != (readerState.dwEventState.intValue() & 0x20))) {
                readerState.dwCurrentState = readerState.dwEventState;
                readerState.dwEventState = new Winscard.Dword(0L);
                long startTime = System.currentTimeMillis();
                Winscard.Dword err = this.libInfo.lib.SCardGetStatusChange(this.cardTerminals.scardContext, new Winscard.Dword(remainingTimeout), rgReaderStates, new Winscard.Dword(rgReaderStates.length));
                long endTime = System.currentTimeMillis();
                if (-2146435062 == err.intValue()) {
                    return false;
                }
                Smartcardio.check("SCardGetStatusChange", err);
                if (remainingTimeout == -1) continue;
                if ((long)remainingTimeout < endTime - startTime) {
                    return false;
                }
                remainingTimeout = (int)((long)remainingTimeout - (endTime - startTime));
            }
            return true;
        }

        @Override
        public boolean waitForCardAbsent(long timeoutMs) throws CardException {
            return this.waitHelper(timeoutMs, false);
        }

        @Override
        public boolean waitForCardPresent(long timeoutMs) throws CardException {
            return this.waitHelper(timeoutMs, true);
        }

        public String toString() {
            return String.format("%s{scardHandle=%s, name=%s}", new Object[]{this.getClass().getSimpleName(), this.cardTerminals.scardContext, this.name});
        }
    }

    public static class JnaCardTerminals
    extends CardTerminals {
        private final Winscard.SCardContext scardContext;
        private final Winscard.WinscardLibInfo libInfo;
        private Winscard.SCardReaderState[] knownReaders;
        private final List<Winscard.SCardReaderState> zombieReaders;
        private final boolean usePnp = true;
        private boolean isClosed;

        public JnaCardTerminals(Winscard.WinscardLibInfo libInfo, Winscard.SCardContext scardContext) {
            this.libInfo = libInfo;
            this.scardContext = scardContext;
            this.knownReaders = JnaCardTerminals.createScardReaderStates(Collections.<String>emptyList(), true, new Winscard.SCardReaderState[0]);
            this.zombieReaders = new ArrayList<Winscard.SCardReaderState>();
        }

        @Override
        public List<CardTerminal> list(CardTerminals.State state) throws CardException {
            int i;
            List<String> filteredReaderNames;
            if (null == state) {
                throw new NullPointerException("State must be non-null. To get all terminals, call list() or list(State.ALL).");
            }
            if (state == CardTerminals.State.CARD_REMOVAL || state == CardTerminals.State.CARD_INSERTION) {
                boolean wasPresent;
                Winscard.SCardReaderState readerState;
                int i2;
                ArrayList<CardTerminal> r = new ArrayList<CardTerminal>();
                for (i2 = 0; i2 < this.knownReaders.length; ++i2) {
                    boolean shouldAdd;
                    readerState = this.knownReaders[i2];
                    if ("\\\\?PnP?\\Notification".equals(readerState.szReader)) continue;
                    wasPresent = 0 != (readerState.dwCurrentState.intValue() & 0x20);
                    boolean isPresent = 0 != (readerState.dwEventState.intValue() & 0x20);
                    int oldCounter = readerState.dwCurrentState.intValue() >> 16 & 0xFFFF;
                    int newCounter = readerState.dwEventState.intValue() >> 16 & 0xFFFF;
                    boolean cardInserted = !wasPresent && isPresent || isPresent && oldCounter < newCounter || oldCounter + 1 < newCounter;
                    boolean cardRemoved = wasPresent && !isPresent || !isPresent && oldCounter < newCounter || oldCounter + 1 < newCounter;
                    boolean bl = shouldAdd = state == CardTerminals.State.CARD_INSERTION && cardInserted || state == CardTerminals.State.CARD_REMOVAL && cardRemoved;
                    if (!shouldAdd) continue;
                    r.add(new JnaCardTerminal(this.libInfo, this, readerState.szReader));
                }
                if (state == CardTerminals.State.CARD_REMOVAL) {
                    for (i2 = 0; i2 < this.zombieReaders.size(); ++i2) {
                        readerState = this.zombieReaders.get(i2);
                        boolean bl = wasPresent = 0 != (readerState.dwCurrentState.intValue() & 0x20);
                        if (!wasPresent) continue;
                        r.add(new JnaCardTerminal(this.libInfo, this, readerState.szReader));
                    }
                }
                return r;
            }
            List<String> readerNames = this.listReaderNames();
            if (readerNames.isEmpty()) {
                return Collections.emptyList();
            }
            if (state == CardTerminals.State.ALL) {
                filteredReaderNames = readerNames;
            } else {
                Winscard.SCardReaderState[] readers = new Winscard.SCardReaderState[readerNames.size()];
                new Winscard.SCardReaderState().toArray(readers);
                for (i = 0; i < readers.length; ++i) {
                    readers[i].szReader = readerNames.get(i);
                }
                Smartcardio.check("SCardGetStatusChange", this.libInfo.lib.SCardGetStatusChange(this.scardContext, new Winscard.Dword(0L), readers, new Winscard.Dword(readers.length)));
                filteredReaderNames = new ArrayList<String>();
                boolean wantPresent = state == CardTerminals.State.CARD_PRESENT;
                for (int i3 = 0; i3 < readers.length; ++i3) {
                    boolean isPresent;
                    boolean bl = isPresent = 0 != (0x20 & readers[i3].dwEventState.intValue());
                    if (wantPresent != isPresent) continue;
                    filteredReaderNames.add(readers[i3].szReader);
                }
            }
            CardTerminal[] cardTerminals = new CardTerminal[filteredReaderNames.size()];
            for (i = 0; i < filteredReaderNames.size(); ++i) {
                String name = filteredReaderNames.get(i);
                cardTerminals[i] = new JnaCardTerminal(this.libInfo, this, name);
            }
            return Collections.unmodifiableList(Arrays.asList(cardTerminals));
        }

        private List<String> listReaderNames() throws JnaPCSCException {
            long err;
            Winscard.DwordByReference pcchReaders = new Winscard.DwordByReference();
            byte[] mszReaders = null;
            ByteBuffer mszReaderGroups = ByteBuffer.allocate("SCard$AllReaders".length() + 2);
            mszReaderGroups.put("SCard$AllReaders".getBytes(Charset.forName("ascii")));
            while ((err = this.libInfo.lib.SCardListReaders(this.scardContext, mszReaderGroups, null, pcchReaders).longValue()) == 0L && (int)(err = this.libInfo.lib.SCardListReaders(this.scardContext, mszReaderGroups, ByteBuffer.wrap(mszReaders = new byte[pcchReaders.getValue().intValue()]), pcchReaders).longValue()) == -2146435064) {
            }
            switch ((int)err) {
                case 0: {
                    List readerNames = Smartcardio.pcsc_multi2jstring(mszReaders);
                    return readerNames;
                }
                case -2146435049: 
                case -2146435026: {
                    return Collections.emptyList();
                }
            }
            Smartcardio.check("SCardListReaders", err);
            throw new IllegalStateException();
        }

        private static Winscard.SCardReaderState[] createScardReaderStates(List<String> readerNames, boolean usePnp, Winscard.SCardReaderState[] oldKnownReaders) {
            Structure[] newKnownReaders = new Winscard.SCardReaderState[readerNames.size() + (usePnp ? 1 : 0)];
            new Winscard.SCardReaderState().toArray(newKnownReaders);
            int i = 0;
            if (usePnp) {
                newKnownReaders[i].szReader = "\\\\?PnP?\\Notification";
                ++i;
            }
            for (String readerName : readerNames) {
                Structure newReader = newKnownReaders[i];
                newReader.szReader = readerName;
                Winscard.SCardReaderState oldReader = null;
                for (int j = 0; j < oldKnownReaders.length; ++j) {
                    if (!readerName.equals(oldKnownReaders[j].szReader)) continue;
                    oldReader = oldKnownReaders[j];
                    break;
                }
                if (oldReader != null) {
                    newReader.dwCurrentState = oldReader.dwCurrentState;
                    newReader.dwEventState = oldReader.dwEventState;
                    newReader.cbAtr = oldReader.cbAtr;
                    newReader.pvUserData = oldReader.pvUserData;
                    System.arraycopy(oldReader.rgbAtr, 0, newReader.rgbAtr, 0, oldReader.cbAtr.intValue());
                }
                ++i;
            }
            return newKnownReaders;
        }

        private boolean updateKnownReaders() throws JnaPCSCException {
            List<String> currentReaderNames = this.listReaderNames();
            boolean isReaderAddedOrRemoved = false;
            int oldReaderCount = 0;
            for (Winscard.SCardReaderState oldReader : this.knownReaders) {
                if ("\\\\?PnP?\\Notification".equals(oldReader.szReader)) continue;
                ++oldReaderCount;
                if (currentReaderNames.contains(oldReader.szReader)) continue;
                isReaderAddedOrRemoved = true;
                this.zombieReaders.add(oldReader);
            }
            boolean bl = isReaderAddedOrRemoved = isReaderAddedOrRemoved || oldReaderCount != currentReaderNames.size();
            if (!isReaderAddedOrRemoved) {
                return isReaderAddedOrRemoved;
            }
            this.knownReaders = JnaCardTerminals.createScardReaderStates(currentReaderNames, true, this.knownReaders);
            Winscard.SCardReaderState[] readers = this.knownReaders.length == 0 ? new Winscard.SCardReaderState[1] : this.knownReaders;
            Smartcardio.check("SCardGetStatusChange", this.libInfo.lib.SCardGetStatusChange(this.scardContext, new Winscard.Dword(0L), readers, new Winscard.Dword(this.knownReaders.length)));
            return true;
        }

        @Override
        public boolean waitForChange(long timeoutMs) throws CardException {
            boolean pnpChange;
            if (timeoutMs < 0L) {
                throw new IllegalArgumentException("Negative timeout " + timeoutMs);
            }
            if (timeoutMs == 0L) {
                timeoutMs = -1L;
            }
            this.zombieReaders.clear();
            if ((Platform.isLinux() || Platform.isMac()) && this.updateKnownReaders()) {
                return true;
            }
            for (Winscard.SCardReaderState reader : this.knownReaders) {
                reader.dwCurrentState = reader.dwEventState;
                reader.dwEventState = new Winscard.Dword(0L);
            }
            Winscard.SCardReaderState[] readers = this.knownReaders.length == 0 ? new Winscard.SCardReaderState[1] : this.knownReaders;
            Winscard.Dword statusError = this.libInfo.lib.SCardGetStatusChange(this.scardContext, new Winscard.Dword(timeoutMs), readers, new Winscard.Dword(readers.length));
            if (-2146435062 == statusError.intValue()) {
                return false;
            }
            Smartcardio.check("SCardGetStatusChange", statusError);
            Winscard.SCardReaderState pnpReader = this.knownReaders[0];
            boolean bl = pnpChange = 0 != (pnpReader.dwEventState.intValue() & 2);
            if (pnpChange) {
                this.updateKnownReaders();
            }
            return true;
        }

        public String toString() {
            return String.format("%s{scardContext=%s}", new Object[]{this.getClass().getSimpleName(), this.scardContext});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws JnaPCSCException {
            JnaCardTerminals jnaCardTerminals = this;
            synchronized (jnaCardTerminals) {
                if (this.isClosed) {
                    return;
                }
                this.isClosed = true;
            }
            Smartcardio.check("SCardReleaseContext", this.libInfo.lib.SCardReleaseContext(this.scardContext));
        }

        public void finalize() throws JnaPCSCException {
            this.close();
        }
    }

    public static class JnaTerminalFactorySpi
    extends TerminalFactorySpi {
        public static final int SCARD_SCOPE_USER = 0;
        public static final int SCARD_SCOPE_TERMINAL = 1;
        public static final int SCARD_SCOPE_SYSTEM = 2;
        private final Winscard.WinscardLibInfo libInfo;

        public JnaTerminalFactorySpi(Object parameter) {
            this(Winscard.openLib());
        }

        public JnaTerminalFactorySpi(Winscard.WinscardLibInfo libInfo) {
            this.libInfo = libInfo;
        }

        @Override
        public CardTerminals engineTerminals() throws EstablishContextException {
            Winscard.SCardContextByReference phContext = new Winscard.SCardContextByReference();
            try {
                Smartcardio.check("SCardEstablishContext", this.libInfo.lib.SCardEstablishContext(new Winscard.Dword(2L), null, null, phContext));
            }
            catch (JnaPCSCException e) {
                throw new EstablishContextException(e);
            }
            Winscard.SCardContext scardContext = phContext.getValue();
            return new JnaCardTerminals(this.libInfo, scardContext);
        }
    }
}

