/*
 * Decompiled with CFR 0.152.
 */
package com.github.anastaciocintra.escpos.image;

import com.github.anastaciocintra.escpos.EscPosConst;
import com.github.anastaciocintra.escpos.image.EscPosImage;
import com.github.anastaciocintra.escpos.image.ImageWrapperInterface;
import java.io.ByteArrayOutputStream;

public class RasterBitImageWrapper
implements EscPosConst,
ImageWrapperInterface {
    protected EscPosConst.Justification justification = EscPosConst.Justification.Left_Default;
    protected RasterBitImageMode rasterBitImageMode = RasterBitImageMode.Normal_Default;

    public RasterBitImageWrapper setJustification(EscPosConst.Justification justification) {
        this.justification = justification;
        return this;
    }

    public RasterBitImageWrapper setRasterBitImageMode(RasterBitImageMode rasterBitImageMode) {
        this.rasterBitImageMode = rasterBitImageMode;
        return this;
    }

    @Override
    public byte[] getBytes(EscPosImage image) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        bytes.write(27);
        bytes.write(97);
        bytes.write(this.justification.value);
        bytes.write(29);
        bytes.write(118);
        bytes.write(48);
        bytes.write(this.rasterBitImageMode.value);
        int horizontalBytes = image.getHorizontalBytesOfRaster();
        int xL = horizontalBytes & 0xFF;
        int xH = (horizontalBytes & 0xFF00) >> 8;
        int verticalBits = image.getHeightOfImageInBits();
        int yL = verticalBits & 0xFF;
        int yH = (verticalBits & 0xFF00) >> 8;
        bytes.write(xL);
        bytes.write(xH);
        bytes.write(yL);
        bytes.write(yH);
        byte[] rasterBytes = image.getRasterBytes().toByteArray();
        bytes.write(rasterBytes, 0, rasterBytes.length);
        return bytes.toByteArray();
    }

    public static enum RasterBitImageMode {
        Normal_Default(0),
        DoubleWidth(1),
        DoubleHeight(2),
        Quadruple(3);

        public int value;

        private RasterBitImageMode(int value) {
            this.value = value;
        }
    }
}

