/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.compilers.DirectExpressionEvaluator;
import net.sf.jasperreports.compilers.DirectExpressionEvaluators;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.fill.ExpressionValues;
import net.sf.jasperreports.engine.fill.FillExpressionDefaultValues;
import net.sf.jasperreports.engine.fill.FillExpressionEstimatedValues;
import net.sf.jasperreports.engine.fill.FillExpressionOldValues;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.SimpleTextExpressionEvaluator;
import net.sf.jasperreports.engine.type.ExpressionTypeEnum;

public class SimpleTextEvaluators
implements DirectExpressionEvaluators {
    private ExpressionValues defaultValues;
    private ExpressionValues oldValues;
    private ExpressionValues estimatedValues;
    private Map<JRExpression, Evaluator> evaluators = new HashMap<JRExpression, Evaluator>();

    @Override
    public void init(JREvaluator evaluator, Map<String, JRFillParameter> parametersMap, Map<String, JRFillField> fieldsMap, Map<String, JRFillVariable> variablesMap) {
        this.defaultValues = new FillExpressionDefaultValues(evaluator, parametersMap, fieldsMap, variablesMap);
        this.oldValues = new FillExpressionOldValues(evaluator, parametersMap, fieldsMap, variablesMap);
        this.estimatedValues = new FillExpressionEstimatedValues(evaluator, parametersMap, fieldsMap, variablesMap);
        this.evaluators.clear();
    }

    @Override
    public DirectExpressionEvaluator getEvaluator(JRExpression expression) {
        if (expression.getType() == ExpressionTypeEnum.SIMPLE_TEXT) {
            Evaluator evaluator = this.evaluators.get(expression);
            if (evaluator == null) {
                evaluator = new Evaluator(expression);
                this.evaluators.put(expression, evaluator);
            }
            return evaluator;
        }
        return null;
    }

    protected class Evaluator
    implements DirectExpressionEvaluator {
        private final JRExpression expression;

        public Evaluator(JRExpression expression) {
            this.expression = expression;
        }

        @Override
        public Object evaluate() {
            return SimpleTextExpressionEvaluator.evaluateExpression(this.expression, SimpleTextEvaluators.this.defaultValues);
        }

        @Override
        public Object evaluateOld() {
            return SimpleTextExpressionEvaluator.evaluateExpression(this.expression, SimpleTextEvaluators.this.oldValues);
        }

        @Override
        public Object evaluateEstimated() {
            return SimpleTextExpressionEvaluator.evaluateExpression(this.expression, SimpleTextEvaluators.this.estimatedValues);
        }
    }
}

