/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.headertoolbar.actions;

import java.util.List;
import net.sf.jasperreports.components.headertoolbar.actions.HideUnhideColumnCommand;
import net.sf.jasperreports.components.headertoolbar.actions.HideUnhideColumnData;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.components.table.util.TableUtil;
import net.sf.jasperreports.web.commands.Command;
import net.sf.jasperreports.web.commands.CommandException;
import net.sf.jasperreports.web.commands.CommandStack;

public class HideUnhideColumnsCommand
implements Command {
    private static final long serialVersionUID = 10200L;
    private StandardTable table;
    private HideUnhideColumnData columnData;
    private CommandStack individualResizeCommandStack;

    public HideUnhideColumnsCommand(StandardTable table, HideUnhideColumnData columnData) {
        this.table = table;
        this.columnData = columnData;
        this.individualResizeCommandStack = new CommandStack();
    }

    @Override
    public void execute() throws CommandException {
        List<BaseColumn> tableColumns = TableUtil.getAllColumns(this.table);
        int[] columnIndexes = this.columnData.getColumnIndexes();
        if (columnIndexes != null) {
            for (int colIndex : columnIndexes) {
                this.individualResizeCommandStack.execute(new HideUnhideColumnCommand((StandardColumn)tableColumns.get(colIndex), this.columnData.getHide()));
            }
        }
    }

    @Override
    public void undo() {
        this.individualResizeCommandStack.undoAll();
    }

    @Override
    public void redo() {
        this.individualResizeCommandStack.redoAll();
    }
}

