/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignExpressionChunk;
import net.sf.jasperreports.engine.util.ExpressionChunkVisitor;
import net.sf.jasperreports.engine.util.JRStringUtil;

public final class JRExpressionUtil {
    public static final String EXCEPTION_MESSAGE_KEY_UNKNOWN_EXPRESSION_CHUNK_TYPE = "util.expression.unknown.expression.chunk.type";
    private static final Pattern SIMPLE_EXPRESSION_PATTERN = Pattern.compile("\\s*\"([^\"]*((?<=\\\\)\"[^\"]*)*)\"\\s*");
    private static final int SIMPLE_EXPRESSION_TEXT_GROUP = 1;
    private static final Pattern TEXT_QUOTE_PATTERN = Pattern.compile("\\\\\"");
    private static final String TEXT_QUOTE_REPLACEMENT = "\"";

    public static String getExpressionText(JRExpression exp) {
        return exp == null ? null : exp.getText();
    }

    public static String getSimpleExpressionText(JRExpression expression) {
        String chunk;
        Matcher matcher;
        JRExpressionChunk[] chunks;
        String value = null;
        if (expression != null && (chunks = expression.getChunks()) != null && chunks.length == 1 && chunks[0].getType() == 1 && (matcher = SIMPLE_EXPRESSION_PATTERN.matcher(chunk = chunks[0].getText())).matches()) {
            String text = matcher.group(1);
            value = TEXT_QUOTE_PATTERN.matcher(text).replaceAll(TEXT_QUOTE_REPLACEMENT);
        }
        return value;
    }

    public static void visitChunks(JRExpression expression, ExpressionChunkVisitor visitor) {
        JRExpressionChunk[] chunks = expression.getChunks();
        if (chunks != null) {
            block7: for (JRExpressionChunk chunk : chunks) {
                switch (chunk.getType()) {
                    case 1: {
                        visitor.visitTextChunk(chunk);
                        continue block7;
                    }
                    case 2: {
                        visitor.visitParameterChunk(chunk);
                        continue block7;
                    }
                    case 3: {
                        visitor.visitFieldChunk(chunk);
                        continue block7;
                    }
                    case 4: {
                        visitor.visitVariableChunk(chunk);
                        continue block7;
                    }
                    case 5: {
                        visitor.visitResourceChunk(chunk);
                        continue block7;
                    }
                    default: {
                        throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNKNOWN_EXPRESSION_CHUNK_TYPE, new Object[]{chunk.getType()});
                    }
                }
            }
        }
    }

    public static String convertSimpleTextExpression(JRExpression expression) {
        JRDesignExpression convertedExpression = null;
        if (expression != null) {
            convertedExpression = new JRDesignExpression();
            JRExpressionChunk[] chunks = expression.getChunks();
            if (chunks != null) {
                for (int i = 0; i < chunks.length; ++i) {
                    JRExpressionChunk chunk = chunks[i];
                    JRDesignExpressionChunk convertedChunk = new JRDesignExpressionChunk();
                    convertedChunk.setType(chunk.getType());
                    if (chunk.getType() == 1) {
                        convertedChunk.setText((i == 0 ? "" : " + ") + TEXT_QUOTE_REPLACEMENT + JRStringUtil.escapeJavaStringLiteral(chunk.getText()) + TEXT_QUOTE_REPLACEMENT + (i == chunks.length - 1 ? "" : " + "));
                    } else {
                        convertedChunk.setText(chunk.getText());
                    }
                    convertedExpression.addChunk(convertedChunk);
                }
            }
        }
        return convertedExpression == null ? null : convertedExpression.getText();
    }

    private JRExpressionUtil() {
    }
}

